package com.spring.ehcache.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

import com.spring.ehcache.repository.EhCacheRepositoryImpl;
import com.spring.ehcache.resource.AppConstant;



@EnableWebMvc
@Configuration
@ComponentScan({AppConstant.Config.BASE_PACKAGE })
@PropertySource(value = { AppConstant.Config.APPLICATION_PROPERTY_SOURCE_PATH })
public class AppConfig {
	
	@Bean
	EhCacheRepositoryImpl ehCacheRepositoryImpl() {
		return new EhCacheRepositoryImpl();
	}
	

}
