package com.spring.ehcache.config;

import java.util.Properties;

import javax.sql.DataSource;

import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.orm.hibernate4.HibernateTransactionManager;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import com.spring.ehcache.resource.AppConstant;

@Configuration
@EnableCaching
@EnableTransactionManagement
@PropertySource(value = { AppConstant.Config.APPLICATION_PROPERTY_SOURCE_PATH })
public class HibernateConfiguration {
	
	@Autowired
	private Environment environment;
	
	@Bean
	public LocalSessionFactoryBean sessionFactory() {
		LocalSessionFactoryBean sessionFactory = new LocalSessionFactoryBean();
		sessionFactory.setDataSource(getDataSource());
		sessionFactory.setPackagesToScan(new String[] { AppConstant.Config.BASE_PACKAGE });
		sessionFactory.setHibernateProperties(hibernateProperties());
		return sessionFactory;
	}
	
	 @Bean  
	    public DataSource getDataSource()
	    {
	        DriverManagerDataSource ds = new DriverManagerDataSource();        
	        ds.setDriverClassName(environment.getRequiredProperty(AppConstant.Config.JDBC_DRIVER_NAME));
	        ds.setUrl(environment.getRequiredProperty(AppConstant.Config.JDBC_URL));
	        ds.setUsername(environment.getRequiredProperty(AppConstant.Config.JDBC_USER_NAME));
	        ds.setPassword(environment.getRequiredProperty(AppConstant.Config.JDBC_PASSWORD));        
	        return ds;
	    }
	 
	 private Properties hibernateProperties() {
			Properties properties = new Properties();
			properties.put(AppConstant.Config.HIBERNATE_DIALECT,
					environment.getRequiredProperty(AppConstant.Config.HIBERNATE_DIALECT));
			properties.put(AppConstant.Config.HIBERNATE_SHOW_SQL,
					environment.getRequiredProperty(AppConstant.Config.HIBERNATE_SHOW_SQL));
			properties.put(AppConstant.Config.HIBERNATE_FORMAT_SQL,
					environment.getRequiredProperty(AppConstant.Config.HIBERNATE_FORMAT_SQL));
			properties.put("hibernate.cache.region.factory_class", "org.hibernate.cache.ehcache.EhCacheRegionFactory");
			properties.put("hibernate.cache.use_second_level_cache","true");
			properties.put("net.sf.ehcache.configurationResourceName", "ehcache.xml");
			properties.put(AppConstant.Config.HIBERNATE_CREATE_UPDATE,
					environment.getRequiredProperty(AppConstant.Config.HIBERNATE_CREATE_UPDATE));
			return properties;
		}
	 	@Bean
	    @Autowired
	    public HibernateTransactionManager transactionManager(SessionFactory sessionFactory)
	    {
	        HibernateTransactionManager htm = new HibernateTransactionManager();
	        htm.setSessionFactory(sessionFactory);
	        return htm;
	    }
}
