package com.spring.ehcache.repository;

import java.util.List;

import org.hibernate.Criteria;
import org.springframework.cache.annotation.Cacheable;

import com.spring.ehcache.entity.EhCacheEntity;

public class EhCacheRepositoryImpl extends EhCacheRepository {
	
	/* @Cacheable indicates that the result of invoking a method (or all methods in a class) can be cached.
	 * Each time an advised method is invoked, the caching behavior will be applied, 
	 * checking whether the method was already invoked for the given arguments.*/
	
	@Cacheable(value = "ehcache")
	public List<EhCacheEntity> getEntity()
	{
		List<EhCacheEntity> myDemoEntitylist = null;
		Criteria cr = currentSession().createCriteria(EhCacheEntity.class);
		myDemoEntitylist = cr.list();
		return myDemoEntitylist;
	}
}
